local function deepcopy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == 'table' then
        copy = {}
        for orig_key, orig_value in pairs(orig) do
            copy[deepcopy(orig_key)] = deepcopy(orig_value)
        end
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end

--Missile types for backward compatibility with AJS37
--11019 = A (01) J (10) S (19) + 11 => 11030
local wsType_Rb24 = 11037
local wsType_Rb24J = 11038
local wsType_Rb74 = 11039

local GAR_8 =
{
	category		= CAT_AIR_TO_AIR,
	name			= "GAR-8", -- AIM-9B
	user_name		= _("AIM-9B"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
	Escort 			= 0,
	Head_Type 		= 1,
	sigma 			= {3, 3, 3},
	M 				= 74.39,
	H_max 			= 18000.0,
	H_min 			= -1,
	Diam 			= 127.0,
	Cx_pil			= 1.68,
	D_max 			= 4000.0,
	D_min 			= 300.0,
	Head_Form 		= 0,
	Life_Time 		= 24.0,
	Nr_max 			= 12,
	v_min 			= 140.0,
	v_mid 			= 350.0,
	Mach_max 		= 3.2,
	t_b 			= 0.0,
	t_acc			= 2.2,
	t_marsh			= 0.0,
	Range_max		= 11000.0,
	H_min_t		    = 1.0,
	Fi_start 		= 0.44,
	Fi_rak 		    = 1.1,
	Fi_excort 		= 0.44, --25deg
	Fi_search 		= 0.034, --2deg
	OmViz_max 		= 0.165, --9.5deg/s
	warhead 		= simple_aa_warhead(10),
	exhaust 		=  { 1, 1, 1, 1 },
	X_back 			= -1.5,
	Y_back 			= 0.0,
	Z_back			= 0.0,
	Reflection		= 0.03,
	KillDistance 	= 7.0,
	PN_gain = 3,
	ccm_k0 = 5.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	--seeker sensivity params
	SeekerSensivityDistance = 5000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	SeekerCooled	 = false, -- True is cooled seeker and false is not cooled seeker.				
	shape_table_data =
	{
		{
			name	 = "GAR-8",
			file	 = "aim-9b",
			life	 = 1,
			fire	 = { 0, 1},
			username = "GAR-8",
			index = WSTYPE_PLACEHOLDER,
		},
	},
	
	supersonic_A_coef_skew = 0.2, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.005, -- площадь выходного сечения сопла
	
	ModelData = 
	{   58 ,  -- model params count
		0.35 ,   -- characteristic square (характеристическая площадь)
		
		-- параметры зависимости Сx
		0.0325, -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.069,  -- Cx_k1 высота пика волнового кризиса
		0.02,   -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.03,  -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.4,   -- Cx_k4 крутизна спада за волновым кризисом 
		0.50,  -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
		
		-- параметры зависимости Cy
		1.8, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.1,  -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1,    -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.14, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
	-- Engine data. Time, fuel flow, thrust.	
	--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		-1.0,	2.2,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		 0.0,		0.0,	8.45,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		 0.0,		0.0,	17170.0,	0.0,	0.0,			0.0,		0.0,           -- thrust, newtons
	
		 24.0, -- таймер самоликвидации, сек
		 21.0, -- время работы энергосистемы, сек
		 0, -- абсолютная высота самоликвидации, м
		 0.5, -- время задержки включения управления (маневр отлета, безопасности), сек
		 1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		 1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		 0.0,  -- синус угла возвышения траектории набора горки
		 30.0, -- продольное ускорения взведения взрывателя
		 0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		 1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		 1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		 2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		 -- DLZ. Данные для рассчета дальностей пуска (индикация на прицеле)
		 4.65   ,
		 -10.98 ,
		 -2.24  ,
		 12880  ,
		 2916   ,
		 21942  , -- дальность ракурс   180(навстречу) град,  Н=10000м, V=900км/ч, м
		 5242   , -- дальность ракурс 0(в догон) град,  Н=10000м, V=900км/ч, м
		 8937   , -- дальность ракурс 	180(навстречу) град, Н=1000м, V=900км/ч, м
		 1918   , -- Уменьшение разрешенной дальности пуска при отклонении вектора скорости носителя от линии визирования цели.
		 2500.0 , -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в нижнюю полусферу. Уменьшение дальности при стрельбе вниз.
		 0.35   , -- Вертикальная плоскость. Наклон кривой разрешенной дальности пуска в верхнюю полусферу. Увеличение дальности при стрельбе вверх.
		-0.01   , -- Вертикальная плоскость. Угол перегиба кривой разрешенной дальности, верхняя - нижняя полусфера.
		 0.5, 	 -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}



local Rb24 = deepcopy(GAR_8)
Rb24.wsTypeOfWeapon[4] = wsType_Rb24
Rb24.name = "Rb 24"
Rb24.user_name = _("Rb 24")
Rb24.shape_table_data[1].name = "Rb 24"
Rb24.shape_table_data[1].username = "Rb 24"
Rb24.shape_table_data[1].index = wsType_Rb24
--TODO replace model

declare_weapon(GAR_8)
declare_weapon(Rb24)

local AIM_9J =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM-9J", -- AIM-9J
	user_name		= _("AIM-9J"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
	Escort = 0,
	Head_Type = 1,
	sigma = {3, 3, 3},
	M = 74.84,
	H_max = 18000.0,
	H_min = -1,
	Diam = 127.0,
	Cx_pil = 1.68,
	D_max = 7000.0,
	D_min = 300.0,
	Head_Form = 0,
	Life_Time = 40.0,
	Nr_max = 22,
	v_min = 140.0,
	v_mid = 350.0,
	Mach_max = 2.5,
	t_b = 0.0,
	t_acc = 2.2,
	t_marsh = 0.0,
	Range_max = 14000.0,
	H_min_t = 1.0,
	Fi_start = 0.3,
	Fi_rak = 1.8,
	Fi_excort = 0.7,
	Fi_search = 0.017,
	OmViz_max = 0.29,
	warhead = simple_aa_warhead(11.0),
	exhaust = { 1, 1, 1, 1 },
	X_back = -1.55,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 7.0,
	--seeker sensivity params
	SeekerSensivityDistance = 7000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	ccm_k0 = 2.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled = true, -- True is cooled seeker and false is not cooled seeker.				
	shape_table_data =
	{
		{
			name	 = "aim-9J",
			file	 = "aim-9J",
			life	 = 1,
			fire	 = {0, 1},
			username = "AIM-9J",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},

	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.005, -- площадь выходного сечения сопла
		
	ModelData = {   58,  -- model params count
					0.35,   -- characteristic square (характеристическая площадь)
	
					-- параметры зависимости Сx
					0.049, -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
					0.082, -- Cx_k1 высота пика волнового кризиса
					0.010, -- Cx_k2 крутизна фронта на подходе к волновому кризису
					0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
					0.550, -- Cx_k4 крутизна спада за волновым кризисом 
					0.8, -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
						
					-- параметры зависимости Cy
					2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
					0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
					1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
						
					0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
					0.00, --угловая скорость создаваймая моментом газовых рулей
						
				-- Engine data. Time, fuel flow, thrust.	
				--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
					-1.0,	   -1.0,	2.2,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
					 0.0,		0.0,	8.45,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
					 0.0,		0.0,	17170.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
					1.0e9, -- таймер самоликвидации, сек
					40.0, -- время работы энергосистемы, сек
					0, -- абсолютная высота самоликвидации, м
					0.8, -- время задержки включения управления (маневр отлета, безопасности), сек
					1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
					1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
					0.0,  -- синус угла возвышения траектории набора горки
					30.0, -- продольное ускорения взведения взрывателя
					0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
					1.2, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
					1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
					2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления
					-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
					7.34,   -- производная дальности по скорости носителя на высоте 1км, ППС
					-7.93,  -- производная дальности по скорости цели на высоте 1км, ЗПС
					-1.96,  -- производная по высоте производной дальности по скорости цели, ЗПС
					11526.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
					2805.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м 
					19655.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
					5192.6,  -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
					7837.1, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
					1786.9, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
					2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
					0.55, -- процент гарантированной дальности от дальности в ППС на высоте 1км
					-0.01, -- производная процента гарантированной дальности в ППС по высоте
					0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
				},
	
	
} 
declare_weapon(AIM_9J)

local AIM9P =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM-9P", -- AIM-9P
	user_name		= _("AIM-9P"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,AIM_9P},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3},
    M = 74.84,
    H_max = 18000.0,
    H_min = -1,
    Diam = 127.0,
    Cx_pil = 1.68,
    D_max = 4000.0,
    D_min = 300.0,
    Head_Form = 0,
    Life_Time = 40.0,
    Nr_max = 22,
    v_min = 140.0,
    v_mid = 350.0,
    Mach_max = 2.2,
    t_b = 0.0,
    t_acc = 2.2,
    t_marsh = 0.0,
    Range_max = 11000.0,
    H_min_t = 1.0,
    Fi_start = 0.3,
    Fi_rak = 2.1,
    Fi_excort = 0.7,
    Fi_search = 0.017,
    OmViz_max = 0.29,
    warhead = predefined_warhead("AIM_9P"),
    exhaust = { 1, 1, 1, 1 },
    X_back = -1.46,
    Y_back = -0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 7.0,
	--seeker sensivity params
	ccm_k0 = 2.0,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	--seeker sensivity params
	SeekerSensivityDistance = 10000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.

	shape_table_data =
	{
		{
			name	 = "aim-9p",
			file	 = "aim-9p",
			life	 = 1,
			fire	 = {0, 1},
			username = "AIM-9P",
			index 	 = AIM_9P,
		},
	},
	
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.005, -- площадь выходного сечения сопла
	
	ModelData = {   58 ,  -- model params count
		0.35 ,   -- characteristic square (характеристическая площадь)
		
		-- параметры зависимости Сx
		0.049, -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.082, -- Cx_k1 высота пика волнового кризиса
		0.010, -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.001,-- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.550,-- Cx_k4 крутизна спада за волновым кризисом 
		0.8, -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
		
		-- параметры зависимости Cy
		2.5, --- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.13,  -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
			
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		   -1.0,	2.2,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	8.45,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	17170.0,	0.0,	    0.0,			0.0,		0.0,           -- thrust, newtons
		
		1.0e9, -- таймер самоликвидации, сек
		40.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		30.0, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		7.34,   
		-7.93,  
		-1.96,  
		11526.0,
		2805.0, 
		19655.0,
		5192.6, 
		7837.1, 
		1786.9, 
		2500.0, 
		0.55, 	
		-0.01, 	
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

local AIM_9P5 =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM-9P5", -- AIM-9P5
	user_name		= _("AIM-9P5"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
	Escort 			= 0,
	Head_Type 		= 1,
	sigma 			= {3, 3, 3},
	M 				= 80.7,
	H_max 			= 18000.0,
	H_min 			= -1,
	Diam 			= 127.0,
	Cx_pil			= 1.68,
	D_max 			= 4000.0,
	D_min 			= 300.0,
	Head_Form 		= 0,
	Life_Time 		= 40.0,
	Nr_max 			= 22,
	v_min 			= 140.0,
	v_mid 			= 350.0,
	Mach_max 		= 2.2,
	t_b 			= 0.0,
	t_acc			= 5.0,
	t_marsh			= 0.0,
	Range_max		= 11000.0,
	H_min_t		    = 1.0,
	Fi_start 		= 0.3,
	Fi_rak 		    = 3.14152,
	Fi_excort 		= 0.7,
	Fi_search 		= 0.031,
	OmViz_max 		= 0.38,
	warhead 		= simple_aa_warhead(11.0),
	exhaust 		= { 0.7, 0.7, 0.7, 0.1 },
	X_back 			= -1.46,
	Y_back 			= 0.0,
	Z_back			= 0.0,
	Reflection		= 0.03,
	KillDistance 	= 7.0,
	ccm_k0 			= 0.75,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	--seeker sensivity params
	SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	SeekerCooled	 		= true, -- True is cooled seeker and false is not cooled seeker.				
	shape_table_data =
	{
		{
			name	 = "aim-9p5",
			file	 = "aim-9p5",
			life	 = 1,
			fire	 = { 0, 1},
			username = "AIM-9P5",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0068, -- площадь выходного сечения сопла
	
	ModelData = 
	{
		58 ,  -- model params count
		0.35 ,   -- characteristic square (характеристическая площадь)
		
		-- параметры зависимости Сx
		0.049, -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.082, -- Cx_k1 высота пика волнового кризиса
		0.010, -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.001,-- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.550,-- Cx_k4 крутизна спада за волновым кризисом 
		0.8,  -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
		
		-- параметры зависимости Cy
		2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.13,  -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.0, --угловая скорость создаваймая моментом газовых рулей
		
	-- Engine data. Time, fuel flow, thrust.	
	--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,		-1.0,	5.0,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		0.0,	4.84,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		0.0,	11020,		0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
	
		 1.0e9, -- таймер самоликвидации, сек
		 40.0, -- время работы энергосистемы, сек
		 0, -- абсолютная высота самоликвидации, м
		 0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
		 1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		 1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		 0.0,  -- синус угла возвышения траектории набора горки
		 30.0, -- продольное ускорения взведения взрывателя
		 0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		 1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		 1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		 2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		 8.0,
		 -11.1,
		 -2.33,
		 16700.5,
		 5040.5,
		 28498.2, 
		 9345.3, 
		 11466.0, 
		 3206.3, 
		 2500, 
		 0.55, 
		 -0.01,
		 0.5, 
	},
}

local AIM_9P3 = deepcopy(AIM9P)

AIM_9P3.wsTypeOfWeapon = {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER}
AIM_9P3.t_acc = AIM_9P5.t_acc
AIM_9P3.exhaust = AIM_9P5.exhaust
AIM_9P3.M = AIM_9P5.M
AIM_9P3.ccm_k0 = AIM9P.ccm_k0
AIM_9P3.ModelData = deepcopy(AIM_9P5.ModelData)
AIM_9P3.shape_table_data = deepcopy(AIM_9P5.shape_table_data)
AIM_9P3.name = "AIM-9P3"
AIM_9P3.user_name = _("AIM-9P3")
AIM_9P3.shape_table_data[1].name = "AIM-9P3"
AIM_9P3.shape_table_data[1].username = "AIM-9P3"

local Rb24J = deepcopy(AIM_9P3)
Rb24J.wsTypeOfWeapon[4] = wsType_Rb24J
Rb24J.name = "Rb 24J"
Rb24J.user_name = _("Rb 24J")
Rb24J.shape_table_data[1].name = "Rb 24J"
Rb24J.shape_table_data[1].username = "Rb 24J"
Rb24J.shape_table_data[1].index = wsType_Rb24J
--TODO replace model

declare_weapon(AIM9P)
declare_weapon(AIM_9P5)
declare_weapon(AIM_9P3)
declare_weapon(Rb24J)

local AIM_9JULI =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM-9JULI", -- AIM-9JULI - foreign J9 + 9L seeker
	user_name		= _("AIM-9JULI"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
	Escort = 0,
	Head_Type = 1,
	sigma = {3, 3, 3},
	M = 82.3,
	H_max = 21000.0,
	H_min = -1,
	Diam = 127.0,
	Cx_pil = 1.68,
	D_max = 7000.0,
	D_min = 300.0,
	Head_Form = 0,
	Life_Time = 40.0,
	Nr_max = 32,
	v_min = 140.0,
	v_mid = 350.0,
	Mach_max = 2.5,
	t_b = 0.0,
	t_acc = 5.0,
	t_marsh = 0.0,
	Range_max = 14000.0,
	H_min_t = 1.0,
	Fi_start = 0.3,
	Fi_rak = 3.14152,
	Fi_excort = 0.79,
	Fi_search = 0.031,
	OmViz_max = 0.44,
	warhead = simple_aa_warhead(11.0),
	exhaust = { 0.7, 0.7, 0.7, 0.1 },
	X_back = -1.6,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 7.0,
	--seeker sensivity params
	SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	ccm_k0 = 0.75,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled = true, -- True is cooled seeker and false is not cooled seeker.				
	shape_table_data =
	{
		{
			name	 = "aim-9JULI",
			file	 = "aim-9JULI", -- TODO replace model
			life	 = 1,
			fire	 = {0, 1},
			username = "AIM-9JULI",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},

	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0068, -- площадь выходного сечения сопла
		
	ModelData = {   58,  -- model params count
					0.35,   -- characteristic square (характеристическая площадь)
	
					-- параметры зависимости Сx
					0.049, -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
					0.082, -- Cx_k1 высота пика волнового кризиса
					0.010, -- Cx_k2 крутизна фронта на подходе к волновому кризису
					0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
					0.550, -- Cx_k4 крутизна спада за волновым кризисом 
					0.8, -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
						
					-- параметры зависимости Cy
					2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
					0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
					1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
						
					0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
					0.00, --угловая скорость создаваймая моментом газовых рулей
						
				-- Engine data. Time, fuel flow, thrust.	
				--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
					-1.0,		-1.0,	5.0,  		0.0,		0.0,			0.0,		1.0e9,        -- time of stage, sec
					0.0,		0.0,	4.96,		0.0,		0.0,			0.0,		0.0,          -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
					 0.0,		0.0,	11280.0,	0.0,	0.0,			0.0,		0.0,              -- thrust, newtons
					
					1.0e9, -- таймер самоликвидации, сек
					40.0, -- время работы энергосистемы, сек
					0, -- абсолютная высота самоликвидации, м
					0.3, -- время задержки включения управления (маневр отлета, безопасности), сек
					1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
					1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
					0.0,  -- синус угла возвышения траектории набора горки
					30.0, -- продольное ускорения взведения взрывателя
					0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
					1.2, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
					1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
					2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления
					-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
					8.05,	-- производная дальности по скорости носителя на высоте 1км, ППС
					-11.65,	-- производная дальности по скорости цели на высоте 1км, ЗПС
					-2.08,	-- производная по высоте производной дальности по скорости цели, ЗПС
					16789.4,	 -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
					4975.8,	-- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м 
					28596.1, 	 -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
					9195.1, 	 -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
					11591.9, 	-- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
					3186.5, 	-- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
					2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
					0.55, -- процент гарантированной дальности от дальности в ППС на высоте 1км
					-0.01, -- производная процента гарантированной дальности в ППС по высоте
					0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
} 
declare_weapon(AIM_9JULI)

local AIM_9L =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM-9L", -- AIM-9L
	user_name		= _("AIM-9L"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
	Escort = 0,
	Head_Type = 1,
	sigma = {3, 3, 3},
	M = 85.73,
	H_max = 18000.0,
	H_min = -1,
	Diam = 127.0,
	Cx_pil = 1.68,
	D_max = 7000.0,
	D_min = 300.0,
	Head_Form = 0,
	Life_Time = 60.0,
	Nr_max = 32,
	v_min = 140.0,
	v_mid = 350.0,
	Mach_max = 2.7,
	t_b = 0.0,
	t_acc = 5.0,
	t_marsh = 0.0,
	Range_max = 14000.0,
	H_min_t = 1.0,
	Fi_start = 0.3,
	Fi_rak = 3.14152,
	Fi_excort = 0.79,
	Fi_search = 0.031,
	OmViz_max = 0.44,
	warhead = simple_aa_warhead(11.0),
	exhaust = { 0.7, 0.7, 0.7, 1.0 },
	X_back = -1.5,
	Y_back = 0.0,
	Z_back = 0.0,
	Reflection = 0.03,
	KillDistance = 7.0,
	--seeker sensivity params
	SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	ccm_k0 = 0.75,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.				
	shape_table_data =
	{
		{
			name	 = "aim-9L",
			file	 = "aim-9L",
			life	 = 1,
			fire	 = { 0, 1},
			username = "AIM-9L",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},

	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0068, -- площадь выходного сечения сопла
		
	ModelData = {   58,  -- model params count
					0.35,   -- characteristic square (характеристическая площадь)
	
					-- параметры зависимости Сx
					0.049, -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
					0.082, -- Cx_k1 высота пика волнового кризиса
					0.010, -- Cx_k2 крутизна фронта на подходе к волновому кризису
					0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
					0.550, -- Cx_k4 крутизна спада за волновым кризисом 
					0.8, -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
						
					-- параметры зависимости Cy
					2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
					0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
					1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
						
					0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
					0.00, --угловая скорость создаваймая моментом газовых рулей
						
				-- Engine data. Time, fuel flow, thrust.	
				--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
					-1.0,	   -1.0,	5.20,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
					 0.0,		0.0,	5.27,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
					 0.0,		0.0,	11890.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
					
					1.0e9, -- таймер самоликвидации, сек
					60.0, -- время работы энергосистемы, сек
					0, -- абсолютная высота самоликвидации, м
					0.8, -- время задержки включения управления (маневр отлета, безопасности), сек
					1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
					1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
					0.0,  -- синус угла возвышения траектории набора горки
					30.0, -- продольное ускорения взведения взрывателя
					0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
					1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
					1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
					2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления
					-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
					9.0, -- производная дальности по скорости носителя на высоте 1км, ППС
					-13.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
					-2.1, -- производная по высоте производной дальности по скорости цели, ЗПС
					15500.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
					5500.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м 
					27000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
					10000.0,  -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
					10500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
					3500.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
					2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
					0.55, -- процент гарантированной дальности от дальности в ППС на высоте 1км
					-0.01, -- производная процента гарантированной дальности в ППС по высоте
					0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
				},
}

local Rb74 = deepcopy(AIM_9L)
Rb74.wsTypeOfWeapon[4] = wsType_Rb74
Rb74.name = "Rb 74"
Rb74.user_name = _("Rb 74")
Rb74.shape_table_data[1].name = "Rb 74"
Rb74.shape_table_data[1].username = "Rb 74"
Rb74.shape_table_data[1].index = wsType_Rb74
--TODO replace model

declare_weapon(AIM_9L)
declare_weapon(Rb74)

local AIM9M =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM_9", -- AIM-9M
	user_name		= _("AIM-9M"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,AIM_9},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3},
    M = 85.73,
    H_max = 18000.0,
    H_min = -1,
    Diam = 127.0,
    Cx_pil = 1.68,
    D_max = 7000.0,
    D_min = 300.0,
    Head_Form = 0,
    Life_Time = 60.0,
    Nr_max = 40,
    v_min = 140.0,
    v_mid = 350.0,
    Mach_max = 2.7,
    t_b = 0.0,
    t_acc = 5.0,
    t_marsh = 0.0,
    Range_max = 14000.0,
    H_min_t = 1.0,
    Fi_start = 0.3,
    Fi_rak = 3.14152,
    Fi_excort = 0.79,
    Fi_search = 0.031,
    OmViz_max = 0.611,
    warhead = predefined_warhead("AIM_9"),
    exhaust = { 0.7, 0.7, 0.7, 0.08 },
    X_back = -1.5,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 7.0,
	--seeker sensivity params
	SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.
	
	shape_table_data =
	{
		{
			name	 = "aim-9",
			file	 = "aim-9",
			life	 = 1,
			fire	 = { 0, 1},
			username = "AIM-9M",
			index 	 = AIM_9,
		},
	},

	supersonic_A_coef_skew = 0.25, -- наклон прямой коэффициента отвала поляры на сверхзвуке
	nozzle_exit_area =	0.0068, -- площадь выходного сечения сопла
		
	ModelData = {   58,  -- model params count
		0.35,   -- characteristic square (характеристическая площадь)
		
		-- параметры зависимости Сx
		0.049, -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
		0.082, -- Cx_k1 высота пика волнового кризиса
		0.010, -- Cx_k2 крутизна фронта на подходе к волновому кризису
		0.001, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
		0.550, -- Cx_k4 крутизна спада за волновым кризисом 
		0.8, -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
		
		-- параметры зависимости Cy
		2.5, -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
		0.8, -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
		1.2, -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
		
		0.13, -- 7 Alfa_max  максимальный балансировачный угол, радианы
		0.00, --угловая скорость создаваймая моментом газовых рулей
		
		-- Engine data. Time, fuel flow, thrust.	
		--	t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end			-- Stage
		-1.0,	       -1.0,	5.20,  		0.0,		0.0,			0.0,		1.0e9,         -- time of stage, sec
		0.0,		    0.0,	5.27,		0.0,		0.0,			0.0,		0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
		0.0,		    0.0,	11890.0,	0.0,		0.0,			0.0,		0.0,           -- thrust, newtons
		
		1.0e9, -- таймер самоликвидации, сек
		60.0, -- время работы энергосистемы, сек
		0, -- абсолютная высота самоликвидации, м
		0.8, -- время задержки включения управления (маневр отлета, безопасности), сек
		1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
		1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
		0.0,  -- синус угла возвышения траектории набора горки
		30.0, -- продольное ускорения взведения взрывателя
		0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
		1.19, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
		1.0, -- характеристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
		2.0, -- характеристика системы САУ-РАКЕТА,  полоса пропускания контура управления
		-- ЗРП. Данные для рассчета дальностей пуска (индикация на прицеле)
		9.0, -- производная дальности по скорости носителя на высоте 1км, ППС
		-13.0, -- производная дальности по скорости цели на высоте 1км, ЗПС
		-2.1, -- производная по высоте производной дальности по скорости цели, ЗПС
		15500.0, -- дальность ракурс 180 град(навстречу), Н=5000м, V=900км/ч, м
		5500.0, -- дальность ракурс 0(в догон) град, Н=5000м, V=900км/ч, м 
		27000.0, -- дальность ракурс 180(навстречу) град, Н=10000м, V=900км/ч, м
		10000.0,  -- дальность ракурс 0(в догон) град, Н=10000м, V=900км/ч, м
		10500.0, -- дальность ракурс 180(навстречу) град, Н=1000м,  V=900км/ч, м
		3500.0, -- дальность ракурс 0(в догон) град, Н=1000м, V=900км/ч, м
		2500.0, -- смещение назад отнсительно нуля задней точки зоны достижимости
		0.55, -- процент гарантированной дальности от дальности в ППС на высоте 1км
		-0.01, -- производная процента гарантированной дальности в ППС по высоте
		0.5, -- Изменение коэффициентов наклона кривой в верхнюю и нижнюю полусферы от высоты носителя.
	},
}

declare_weapon(AIM9M)

local AIM9X =
{
	category		= CAT_AIR_TO_AIR,
	name			= "AIM_9X", -- AIM-9M
	user_name		= _("AIM-132 ASRAAM IR AAM"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,AIM_9X}, 
     Escort          = 0,
    Head_Type       = 1,
    sigma           = {2, 2, 2},  
	M               = 88,
        H_max = 20000.0, 
        H_min = -1,
        Diam = 166.0,
        Cx_pil = 2.1,
        D_max = 28000.0,
        D_min = 200.0,
        Head_Form = 0,
        Life_Time = 80.0,
        Nr_max = 60,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 3.5,
        t_b = 0.0,
        t_acc = 8.0,
        t_marsh = 0.0,
        Range_max = 35000.0,
        H_min_t = 1.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152, 
        Fi_search = 0.09, 
        OmViz_max = 1.10,
    warhead = predefined_warhead("AIM_9X"),  
    exhaust = { 0.84, 0.66, 0.43, 0.08 };				
		X_back = -1.78,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.040,
        KillDistance = 8.0,
	--seeker sensivity params
	SeekerSensivityDistance = 35000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	ccm_k0 = 0.15,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.

	shape_table_data =
	{
		{
			name	 = "aim-9x",
			file	 = "jas39_asraam",
			life	 = 1,
			fire	 = { 0, 1},
			username = "AIM-9X",
			index 	 = AIM_9X,
		},
	},

	ModelData = {   
		58 ,  -- model params count
        0.4 ,   -- characteristic square (характеристическая площадь)
        
        -- параметры зависимости Сx
        0.040 , -- Cx_k0 планка Сx0 на дозвуке ( M << 1)
        0.080 , -- Cx_k1 высота пика волнового кризиса
        0.020 , -- Cx_k2 крутизна фронта на подходе к волновому кризису
        0.050, -- Cx_k3 планка Cx0 на сверхзвуке ( M >> 1)
        1.0 , -- Cx_k4 крутизна спада за волновым кризисом 
        0.8 , -- коэффициент отвала поляры (пропорционально sqrt (M^2-1))
        
        -- параметры зависимости Cy
        0.9 , -- Cy_k0 планка Сy0 на дозвуке ( M << 1)
        0.8 , -- Cy_k1 планка Cy0 на сверхзвуке ( M >> 1)
        1.2  , -- Cy_k2 крутизна спада(фронта) за волновым кризисом  
        
        0.7 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
        10.0, --угловая скорость создаваймая моментом газовых рулей
        
        -- Engine data. Time, fuel flow, thrust.    
        --    t_statr        t_b        t_accel        t_march        t_inertial        t_break        t_end            -- Stage
        -1.0,        -1.0,    8,          0.0,        0.0,            0.0,        1.0e9,         -- time of stage, sec
         0.0,        0.0,    5.5,        0.0,        0.0,            0.0,        0.0,           -- fuel flow rate in second, kg/sec(секундный расход массы топлива кг/сек)
         0.0,        0.0,    17800.0,    0.0,    0.0,            0.0,        0.0,           -- thrust, newtons
    
         1.0e9, -- таймер самоликвидации, сек
         60.0, -- время работы энергосистемы, сек
         0, -- абсолютная высота самоликвидации, м
         0.5, -- время задержки включения управления (маневр отлета, безопасности), сек
         1.0e9, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр "горка", м
         1.0e9, -- дальность до цели, при которой маневр "горка" завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м 
         0.0,  -- синус угла возвышения траектории набора горки
         50.0, -- продольное ускорения взведения взрывателя
         0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
         1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
         1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
         2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

          -- DLZ. Данные для рассчета дальностей пуска (индикация на прицеле)
		 14.0, 
		 -15.0, 
		 -2.5, 
		 21300, 
		 7300, 
		 35500,
		 13700, 
		 14500, 
		 4200, 
		 1500, 
		 0.5, 
		 -0.015, 
		 0.5,
	},
}

declare_weapon(AIM9X)

local CATM9 =
{
	category		= CAT_AIR_TO_AIR,
	name			= "CATM_9M",
	user_name		= _("CATM-9M"),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_TRAIN_Missile,CATM_9},
    Escort = 0,
    Head_Type = 1,
	sigma = {3, 3, 3},
    M = 85.73,
    H_max = 18000.0,
    H_min = -1,
    Diam = 127.0,
    Cx_pil = 1.88,
    D_max = 7000.0,
    D_min = 300.0,
    Head_Form = 0,
    Life_Time = 60.0,
    Nr_max = 40,
    v_min = 140.0,
    v_mid = 350.0,
    Mach_max = 2.7,
    t_b = 0.0,
    t_acc = 5.0,
    t_marsh = 0.0,
    Range_max = 14000.0,
    H_min_t = 1.0,
    Fi_start = 0.3,
    Fi_rak = 3.14152,
    Fi_excort = 0.79,
    Fi_search = 0.028,
    OmViz_max = 0.611,
    warhead = predefined_warhead("AIM_9"),
    exhaust = { 0.7, 0.7, 0.7, 0.08 };
    X_back = -1.6,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 7.0,
	--seeker sensivity params
	SeekerSensivityDistance = 20000, -- The range of target with IR value = 1. In meters. In forward hemisphere.
	ccm_k0 = 0.5,  -- Counter Countermeasures Probability Factor. Value = 0 - missile has absolutely resistance to countermeasures. Default = 1 (medium probability)
	SeekerCooled			= true, -- True is cooled seeker and false is not cooled seeker.
	
	shape_table_data =
	{
		{
			name	 = "CATM-9M",
			file	 = "catm-9",
			life	 = 1,
			fire	 = { 0, 1},
			username = "CATM-9M",
			index 	 = CATM_9,
		},
	},
}

declare_weapon(CATM9)

local desc_sidwinder = " ".._("Sidewinder IR AAM")

local aim9_variants =
{
	["AIM-9"]  		= {picture = "us_AIM-9L.png",   CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", display_name = AIM9M.user_name ..desc_sidwinder	  	,wstype = AIM9M.wsTypeOfWeapon,	    category = CAT_AIR_TO_AIR, mass = AIM9M.M },
	["AIM-9P"] 		= {picture = "us_AIM-9P.png",   CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}", display_name = AIM9P.user_name ..desc_sidwinder	  	,wstype = AIM9P.wsTypeOfWeapon,	    category = CAT_AIR_TO_AIR, mass = AIM9P.M },
	["AIM-9X"] 		= {picture = "us_AIM-9X.png",   CLSID = "", display_name = AIM9X.user_name ..desc_sidwinder	  	,wstype = AIM9X.wsTypeOfWeapon,	    category = CAT_AIR_TO_AIR, mass = AIM9X.M },
	["CATM-9M"] 	= {picture = "us_CATM-9.png",   CLSID = "CATM-9M", 								  display_name = _("Captive AIM-9M for ACM")	  	 	,wstype = CATM9.wsTypeOfWeapon,	    category = CAT_AIR_TO_AIR, mass = CATM9.M },
	["ais-pod-t50"] = {picture = "ais-pod-t50.png",                                                   display_name = _("AN/ASQ-T50 TCTS Pod - ACMI Pod")	,wstype = {4,	15,	47	,	 108},	category = CAT_PODS,       mass = 62.6  },
	["GAR-8"]		= {picture = "us_AIM-9B.png",   CLSID = "{AIM-9B}",                               display_name = GAR_8.user_name  ..desc_sidwinder      ,wstype = GAR_8.wsTypeOfWeapon,		category = CAT_AIR_TO_AIR, mass = GAR_8.M },
	["AIM-9P5"]		= {picture = "us_AIM-9P-5.png", CLSID = "{AIM-9P5}",							  display_name = AIM_9P5.user_name  ..desc_sidwinder	,wstype = AIM_9P5.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_9P5.M },
	["AIM-9L"]		= {picture = "us_AIM-9L.png",   CLSID = "{AIM-9L}", 							  display_name = AIM_9L.user_name ..desc_sidwinder 		,wstype = AIM_9L.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_9L.M },
	["AIM-9J"]		= {picture = "us_AIM-9P.png",   CLSID = "{AIM-9J}", 							  display_name = AIM_9J.user_name ..desc_sidwinder 		,wstype = AIM_9J.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_9J.M },
	["AIM-9JULI"]	= {picture = "us_AIM-9P.png",   CLSID = "{AIM-9JULI}", 							  display_name = AIM_9JULI.user_name ..desc_sidwinder 	,wstype = AIM_9JULI.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_9JULI.M },
	["AIM-9P3"]		= {picture = "us_AIM-9P.png",   CLSID = "{AIM-9P3}",							  display_name = AIM_9P3.user_name  ..desc_sidwinder	,wstype = AIM_9P3.wsTypeOfWeapon,	category = CAT_AIR_TO_AIR, mass = AIM_9P3.M },
	["Rb_24"]	    = {picture = "us_AIM-9B.png",   CLSID = "{Rb_24}",							      display_name = Rb24.user_name.. " (AIM-9B)"..desc_sidwinder, wstype = Rb24.wsTypeOfWeapon, category = CAT_AIR_TO_AIR, mass = Rb24.M },
	["Rb_24J"]	    = {picture = "us_AIM-9P.png",   CLSID = "{Rb_24J}",							  display_name = Rb24J.user_name.. " (AIM-9P3)"..desc_sidwinder, wstype = Rb24J.wsTypeOfWeapon, category = CAT_AIR_TO_AIR, mass = Rb24J.M },
	["Rb_74"]	    = {picture = "us_AIM-9L.png",   CLSID = "{Rb_74}",							  display_name = Rb74.user_name.. " (AIM-9L)"..desc_sidwinder, wstype = Rb74.wsTypeOfWeapon, category = CAT_AIR_TO_AIR, mass = Rb74.M },
}

local AIM9_DRAG  			  = AIM_9L.Cx_pil / 4096.0 -- 4096 - magic number from long time ago when flanker was 1.5 

local AIM9_DRAG_WITH_ADAPTER  = 0.00014 -- TODO verify this value 
local function aim_9_with_adapter(CLSID,aim_9_variant)
	local var 	   = aim9_variants[aim_9_variant] or aim9_variants["AIM-9"]
	local var_mass = var.mass or 85.5
	declare_loadout({
		category			= var.category,
		CLSID 				= CLSID,
		Picture				= var.picture,
        PictureBlendColor   = "0xffffffff",
		displayName			=	"LAU-7 with".." "..var.display_name,
		wsTypeOfWeapon		=   var.wstype,
		attribute			=	{4,	4,	32,	111},
		Cx_pil				=	AIM9_DRAG_WITH_ADAPTER,
		Count				=	1,
		Weight_Empty		=	15,
		Weight				=	15 + var_mass,
		Elements			=	
		{
			{	ShapeName	=	"aero-3b"	   	  ,	IsAdapter  	   =   true  }, 
			{	ShapeName	=	aim_9_variant	  ,	connector_name =  "Point"},
		}-- end of Elements
	})
end


local function aim_9_without_adapter(CLSID,aim_9_variant)
	local var = aim9_variants[aim_9_variant] or aim9_variants["AIM-9"]
	local var_mass = var.mass or 85.5
	declare_loadout({
		category			= 	var.category,
		CLSID 				= 	CLSID,
		Picture				=	var.picture,
        PictureBlendColor   = "0xffffffff",
		displayName			=	var.display_name,
		attribute			=	var.wstype,
		Cx_pil				=	AIM9_DRAG,
		Count				=	1,
		Weight				=	var_mass,
		Elements			=  {{ShapeName = aim_9_variant}}-- end of Elements 
	})

-----------------------------------------------------------------------------------------------------------------------
--								  				AIM-132 ASRAAM IR AAM					                             --
-----------------------------------------------------------------------------------------------------------------------
	
	declare_loadout({
		category		= CAT_AIR_TO_AIR, 
		CLSID	 		= "{5CE2FF2A-645A-4197-B48D-8720AC69394F}", 
		wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,AIM_9X},    
		attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
		Count 			= 1,
		Cx_pil			= 0.0,
		Picture			= "jas39_asraam.png",
		displayName		= _("AIM-132 ASRAAM IR AAM"),      
		Weight			= 89,
		ejectImpulse    = 140,
		Elements = {{
			
			Position	=	{-0.35,	0, 0}, --1           
			ShapeName	=	"jas39_asraam",
			Rotation = {0,0,0},
			
			}},


	})

-----------------------------------------------------------------------------------------------------------------------
--								  				AIM-132 ASRAAM IR AAM   		                                     --
-----------------------------------------------------------------------------------------------------------------------	
	
	
end

local function lau_105_sidewinder(clsid,element,left,right)
	local var 	   = aim9_variants[element] or aim9_variants["AIM-9"]
	local var_mass = var.mass or 85.5

	local sz = 0.0
	if left == true then sz=sz+1.0 end
	if right == true then sz=sz+1.0 end

	local ret = {
		category			=	var.category,
		CLSID				=	clsid,
		Picture				=	var.picture,
        PictureBlendColor   = "0xffffffff",
		wsTypeOfWeapon		=	var.wstype,
		attribute			=	{4,	4,	32,	50},
		Cx_pil				=	lau105DRA_drag + AIM9_DRAG * sz,
		Elements 			= {{ShapeName	=	"lau-105",IsAdapter  	   =   true  }}
	}
	if left then 	ret.Elements[#ret.Elements + 1] = {ShapeName	    =	 element,connector_name =	"Point_Pilon L" , Rotation		= 	{ 90,0,0}}	end --rotation because LAU-105 have bugged connector pos
	if right then	ret.Elements[#ret.Elements + 1] = {ShapeName		=	 element,connector_name =	"Point_Pilon R" , Rotation		= 	{ 90,0,0}}	end --rotation because LAU-105 have bugged connector pos
	
	ret.Count			= sz
	ret.Weight_Empty	= lau105_weight * 2 + DRA_weight
	ret.Weight			= ret.Weight_Empty + var_mass * sz

	if sz > 1 then
		ret.displayName =	_("LAU-105 with").." 2 x "..var.display_name
	else
		ret.displayName =	_("LAU-105 with").." 1 x "..var.display_name
	end
	declare_loadout(ret)
end

local function lau_115_2x127_sidewinder(clsid,element,left,right)
	local var 	   = aim9_variants[element] or aim9_variants["AIM-9P"]
	local var_mass = var.mass or 85.5
		
	local sz = 0
	if left then 	sz = sz +1 end
	if right then	sz = sz +1 end

	local ret = {
		category			=	var.category,
		CLSID				=	clsid,
		Picture				=	var.picture,
        PictureBlendColor   = "0xffffffff",
		wsTypeOfWeapon		=	var.wstype,
		attribute			=	{4,	4,	32,	146},
		Count				=	sz,
		Weight_Empty		=	lau115_weight + lau127_weight * 2,
		Weight				=	lau115_weight + lau127_weight * 2 + var_mass * sz,
		Cx_pil				=	0.000739765625 + sz * AIM9_DRAG,
		Elements 			= {{ShapeName	=	"LAU-115C+2_LAU127",IsAdapter  	   =   true  }}
	}
	if left then 	ret.Elements[#ret.Elements + 1] = {ShapeName	    =	 element,connector_name =	"Point03" }	end --rotation because LAU-127 have bugged connector pos
	if right then	ret.Elements[#ret.Elements + 1] = {ShapeName		=	 element,connector_name =	"Point02" }	end --rotation because LAU-127 have bugged connector pos
	
	if sz > 1 then
		ret.displayName =	_("LAU-115 with").." 2 x LAU-127 "..var.display_name
	else
		ret.displayName =	_("LAU-115 with").." 1 x LAU-127 "..var.display_name
	end
	declare_loadout(ret)
end

local function lau_127_aim_9(clsid,element)	--uses wrong method for drag calculation
	local var 	   = aim9_variants[element] or aim9_variants["AIM-9P"]
	local var_mass = var.mass or 85.5
	
	local ret = {
		category			=	CAT_AIR_TO_AIR,
		CLSID				=	clsid,
		Picture				=	var.picture,
        PictureBlendColor   = "0xffffffff",
		wsTypeOfWeapon		=	var.wstype,
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	AIM9_DRAG_WITH_ADAPTER,
		Count				=	1,
		Weight_Empty		= 	lau127_weight,
		Weight				=	lau127_weight + var_mass,
		Elements			=	
		{
			{	ShapeName	=	"LAU_127"	   	  ,	IsAdapter  	   =   true  }, 
--			{	ShapeName	= element.shape_table_data.name,	connector_name =  "Point01"},
			{	payload_CLSID =	 var.CLSID,	connector_name =  "Point01"}
		}-- end of Elements
	}
	ret.displayName =	_("LAU-127").." "..var.display_name
	declare_loadout(ret)
	
	return ret
end

--[[ deprecated--]]
local function lau_115_lau_127_aim_9(clsid,element)
	local ret = {
		category			=	CAT_AIR_TO_AIR,
		CLSID				=	clsid,
		Picture				=	element.Picture or  "aim9m.png",
		PictureBlendColor	= "0xffffffff",
		wsTypeOfWeapon		=	element.wsTypeOfWeapon, -- !ATTENTION wsTypeOfWeapon cannot be intermediate container - it always should be actual final weapon type 
		attribute			=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
		Cx_pil				=	AIM9_DRAG_WITH_ADAPTER,
		Count				=	1,
		Weight_Empty		= 	lau115_weight + element.Weight_Empty,
		Weight				=	lau115_weight + element.Weight,
		Elements			=	
		{
			{	ShapeName	=	"LAU-115C"	   	  ,	IsAdapter  	   =   true  }, 
			{	payload_CLSID = element.CLSID, connector_name =  "Point01"}
		}-- end of Elements
	}
	ret.displayName =	_("LAU-115C with").." "..element.displayName
	declare_loadout(ret)
end

local function f4e_sidewinder(clsid,element,left,right)	--uses wrong method for drag calculation

	local var	   = aim9_variants[element] or aim9_variants["AIM-9"]
	local var_mass = var.mass or 85.5
	local ret = {
		category			=	var.category,
		CLSID				=	clsid,
		Picture				=	var.picture,
        PictureBlendColor   = "0xffffffff",
		wsTypeOfWeapon		=	var.wstype,
		attribute			=	{4,	4,	32,	61},
		Cx_pil				=	AIM9_DRAG_WITH_ADAPTER,
		Elements 			= {{ShapeName	=	"F4-PILON",IsAdapter  	   =   true  }}
	}
	if left then 	ret.Elements[#ret.Elements + 1] = {ShapeName	    =	 element,Rotation		= 	{ 90,0,0},Position	= {0.465,	0.00,	-0.28}}	end
	if right then	ret.Elements[#ret.Elements + 1] = {ShapeName		=	 element,Rotation		= 	{-90,0,0},Position	= {0.465,	0.00,	 0.28}}	end
	
	local sz = #ret.Elements - 1
	ret.Count  = sz
	ret.Weight = 30 + var_mass *  sz
	
	if sz > 1 then
		ret.displayName =	_("LAU-7 with").." 2 x "..var.display_name
	else
		ret.displayName =	_("LAU-7 with").." "..var.display_name
	end
	declare_loadout(ret)
end

---------------------------------------------------------------------------------
aim_9_without_adapter("{AIM-9B}"							  ,"GAR-8")
aim_9_without_adapter("{AIM-9J}"							  ,"AIM-9J")
aim_9_without_adapter("{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}","AIM-9P")
aim_9_without_adapter("{AIM-9P5}"							  ,"AIM-9P5")
aim_9_without_adapter("{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}","AIM-9")
aim_9_without_adapter("{5CE2FF2A-645A-4197-B48D-8720AC69394F}","AIM-9X")
aim_9_without_adapter("CATM-9M"								  ,"CATM-9M")
aim_9_without_adapter("{AIS_ASQ_T50}"						  ,"ais-pod-t50")
aim_9_without_adapter("{AIM-9L}"						  	  ,"AIM-9L")
aim_9_without_adapter("{AIM-9JULI}"						  	  ,"AIM-9JULI")
aim_9_without_adapter("{Rb_24}"							      ,"Rb_24")
aim_9_without_adapter("{Rb_24J}"							  ,"Rb_24J")
aim_9_without_adapter("{Rb_74}"							      ,"Rb_74")
---------------------------------------------------------------------------------
aim_9_with_adapter	 ("{GAR-8}"								  ,"GAR-8")
aim_9_with_adapter	 ("{AIM-9J-ON-ADAPTER}"					  ,"AIM-9J")
aim_9_with_adapter	 ("{AIM-9P-ON-ADAPTER}"					  ,"AIM-9P")
aim_9_with_adapter	 ("{AIM-9P5-ON-ADAPTER}"				  ,"AIM-9P5")
aim_9_with_adapter	 ("{AIM-9M-ON-ADAPTER}"					  ,"AIM-9")
aim_9_with_adapter	 ("{AIM-9X-ON-ADAPTER}"					  ,"AIM-9X")
aim_9_with_adapter   ("{Robot24}"							  ,"Rb_24") -- for backward compatibility with AJS37
aim_9_with_adapter   ("{Robot24J}"							  ,"Rb_24J")-- for backward compatibility with AJS37
aim_9_with_adapter   ("{Robot74}"							  ,"Rb_74") -- for backward compatibility with AJS37
---------------------------------------------------------------------------------
lau_105_sidewinder("{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}","AIM-9",true ,true)
lau_105_sidewinder("LAU-105_1*AIM-9M_L"					   ,"AIM-9",true ,false)
lau_105_sidewinder("LAU-105_1*AIM-9M_R"					   ,"AIM-9"	,false,true)
lau_105_sidewinder("{3C0745ED-8B0B-42eb-B907-5BD5C1717447}","AIM-9P",true ,true)
lau_105_sidewinder("LAU-105_2*AIM-9P5"					   ,"AIM-9P5",true ,true)
lau_105_sidewinder("LAU-105_2*AIM-9L"					   ,"AIM-9L",true ,true)
lau_105_sidewinder("LAU-105_1*AIM-9L_L"					   ,"AIM-9L",true ,false)
lau_105_sidewinder("LAU-105_1*AIM-9L_R"					   ,"AIM-9L",false,true)
---------------------------------------------------------------------------------
lau_105_sidewinder("LAU-105_2*CATM-9M"					   ,"CATM-9M",true,true)
lau_105_sidewinder("LAU-105_1*CATM-9M_L"				   ,"CATM-9M",true,false)
lau_105_sidewinder("LAU-105_1*CATM-9M_R"				   ,"CATM-9M",false,true)
lau_105_sidewinder("LAU-105_AIS_ASQ_T50_L"				   ,"ais-pod-t50",true,false)
lau_105_sidewinder("LAU-105_AIS_ASQ_T50_R"				   ,"ais-pod-t50",false,true)
---------------------------------------------------------------------------------
f4e_sidewinder("{F4-2-AIM9B}"						   ,"GAR-8"  ,true,true)
f4e_sidewinder("{773675AB-7C29-422f-AFD8-32844A7B7F17}","AIM-9P" ,true,true)
f4e_sidewinder("{F4-2-AIM9P5}"						   ,"AIM-9P5",true,true)
f4e_sidewinder("{9DDF5297-94B9-42FC-A45E-6E316121CD85}","AIM-9"  ,true,true)
f4e_sidewinder("{F4-2-AIM9L}"						   ,"AIM-9L"  ,true,true)
f4e_sidewinder("{LAU-7_AIS_ASQ_T50}"  			   	   ,"ais-pod-t50",true,false)
---------------------------------------------------------------------------------

lau_127_9X 		= lau_127_aim_9("LAU-127_AIM-9X"	,"AIM-9X")
lau_127_9M 		= lau_127_aim_9("LAU-127_AIM-9M"	,"AIM-9")
lau_127_9L 		= lau_127_aim_9("LAU-127_AIM-9L"	,"AIM-9L")
lau_127_CATM9 	= lau_127_aim_9("LAU-127_CATM-9M"	,"CATM-9M")

lau_115_2x127_sidewinder("LAU-115_2*LAU-127_AIM-9M"	,"AIM-9",true,true)
lau_115_2x127_sidewinder("LAU-115_2*LAU-127_CATM-9M","CATM-9M",true,true)
lau_115_2x127_sidewinder("LAU-115_2*LAU-127_AIM-9L"	,"AIM-9L",true,true)
lau_115_2x127_sidewinder("LAU-115_2*LAU-127_AIM-9X"	,"AIM-9X",true,true)

lau_115_2x127_sidewinder("LAU-115_LAU-127_AIM-9M"	,"AIM-9",true,false)
lau_115_2x127_sidewinder("LAU-115_LAU-127_CATM-9M","CATM-9M",true,false)
lau_115_2x127_sidewinder("LAU-115_LAU-127_AIM-9L"	,"AIM-9L",true,false)
lau_115_2x127_sidewinder("LAU-115_LAU-127_AIM-9X"	,"AIM-9X",true,false)

lau_115_2x127_sidewinder("LAU-115_LAU-127_AIM-9M_R"	,"AIM-9",false,true)
lau_115_2x127_sidewinder("LAU-115_LAU-127_CATM-9M_R","CATM-9M",false,true)
lau_115_2x127_sidewinder("LAU-115_LAU-127_AIM-9L_R"	,"AIM-9L",false,true)
lau_115_2x127_sidewinder("LAU-115_LAU-127_AIM-9X_R"	,"AIM-9X",false,true)


